/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationErrorIds;
import com.ibm.hwmca.fw.ntfy.DescriptiveObject;
import com.ibm.hwmca.fw.ntfy.FilterList;
import com.ibm.hwmca.fw.ntfy.NotificationService;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;

public abstract class AbstractSink
extends DescriptiveObject
implements Serializable,
NotificationErrorIds {
    static final long serialVersionUID = -1287979342911438811L;
    private static final String TRACE_MASKT = "XNTYASIT";
    private static final String TRACE_MASKF = "XNTYASIF";
    private static final String TRACE_MASKD = "XNTYASID";
    protected Map _users;
    protected FilterList _filters;

    public AbstractSink() {
    }

    public AbstractSink(String name, String description, FilterList filters, Map users) {
        super(name, description);
        this._users = users;
        this._filters = filters;
    }

    public abstract void perform(EventObject var1, Collection var2);

    public boolean pass(EventObject event) {
        boolean passed;
        boolean bl = passed = super.pass(event) && this.getFilters().pass(event);
        if (passed) {
            this.perform(event, this.getUsers().values());
        }
        return passed;
    }

    public FilterList getFilters() {
        return this._filters;
    }

    public boolean isEnabled() {
        boolean enabled = NotificationService.getManager().isEnabled() && this.isClassEnabled() && super.isEnabled();
        Trace.trace(TRACE_MASKF, "isEnabled:  " + enabled);
        return enabled;
    }

    private boolean isClassEnabled() {
        boolean enabled = NotificationService.getManager().getSinkClassProperties(this.getClass().getName()).isEnabled();
        Trace.trace(TRACE_MASKF, "isClassEnabled:  " + enabled);
        return enabled;
    }

    public StringBuffer parms() {
        StringBuffer parms = super.parms();
        parms.append(", enabled=");
        parms.append(this.isEnabled() ? "true" : "false");
        return parms;
    }

    public Map getUsers() {
        return this._users;
    }

    public void setUsers(Map users) {
        this._users = users;
    }
}

